/* 
 *  PreviewDialRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.ContactNumberI;

public class PreviewDialRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(PreviewDialRequest.class);
    private final ContactNumberI toDial;

    public PreviewDialRequest(String interactionID, ContactNumberI toDial) {
        super(LOG, interactionID);
        this.toDial = toDial;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().previewDial(toDial);
        LOG.trace(methodName + "-");
        return null;
    }
}
